﻿using System.Numerics;
using System.Threading.Tasks;

namespace ParallelFor
{
    class Program
    {
        static void Main(string[] args)
        {
        }

        // Listing 16-24. Metoda Parallel.For
        static int[,] CalculateMandelbrotValues(int pixelWidth, int pixelHeight,
            double left, double top, double width, double height, int maxIterations)
        {
            int[,] results = new int[pixelWidth, pixelHeight];

            // Nierównoległa wersja poniższego wiersza wyglądałaby następująco:
            // for(int pixelY = 0; pixelY < pixelHeight; ++pixelY)
            Parallel.For(0, pixelHeight, pixelY =>
            {
                double y = top + (pixelY * height) / (double) pixelHeight;
                for (int pixelX = 0; pixelX < pixelWidth; ++pixelX)
                {
                    double x = left + (pixelX * width) / (double) pixelWidth;
                    // Uwaga: ten typ jest dostępny w przestrzeni nazw System.Numerics 
                    // dostępnej w podzespole System.Numerics.
                    Complex c = new Complex(x, y);
                    Complex z = new Complex();

                    int iter;
                    for (iter = 1; z.Magnitude < 2 && iter < maxIterations; ++iter)
                    {
                        z = z * z + c;
                    }
                    if (iter == maxIterations) { iter = 0; }
                    results[pixelX, pixelY] = iter;
                }
            });

            return results;
        }
    }
}
